# Tournament Play Enhancements (1.5) by Windyplains

strings = [
###########################################################################################################################
#####                                                   TPE STRINGS                                                   #####
###########################################################################################################################
	
	# Menu strings
	("tpe_round_1", "first"),
	("tpe_round_2", "second"),
	("tpe_round_3", "third"),
	("tpe_round_4", "fourth"),
	("tpe_round_5", "fifth"),
	("tpe_round_6", "final"),
	
	# Ranking Strings
	("tpe_rank_1",  "Enemies know to flee when you approach!"),
	("tpe_rank_2",  "Opponents know you are near by the wails of your victims!"),
	("tpe_rank_3",  "Other men are wary of your presence on the field."),
	("tpe_rank_4",  "You are mostly ignored by others on the field of battle."),
	("tpe_rank_5",  "Opponents seek you out on the field looking for easy points!"),
	
	# Awarding Points
	("tpe_award_point_eliminate_opponent",   "for eliminating an opponent"),
	("tpe_award_point_winning_team",         "for winning the round"),
	("tpe_award_point_highest_scoring_team", "for his team scoring the highest"),
	
	# Titles Names
	("tpe_title_captain",   "Captain"),
	("tpe_title_knight",    "Sir"),
	("tpe_title_guardsman", "Guardsman"),
	("tpe_titles_end",      "End"),

	# Standard Medieval Names - Appropriate for Swadia & Rhodoks
	("tpe_name_00", "Adam"),
	("tpe_name_01", "Ademar"),
	("tpe_name_02", "Aimery"),
	("tpe_name_03", "Aimone"),
	("tpe_name_04", "Alain"),
	("tpe_name_05", "Albert"),
	("tpe_name_06", "Alexander"),
	("tpe_name_07", "Alexandre"),
	("tpe_name_08", "Alfonse"),
	("tpe_name_09", "Alfonso"),
	("tpe_name_10", "Alois"),
	("tpe_name_11", "Alond"),
	("tpe_name_12", "Amoury"),
	("tpe_name_13", "Andre"),
	("tpe_name_14", "Antoine"),
	("tpe_name_15", "Arnaldo"),
	("tpe_name_16", "Arnaud"),
	("tpe_name_17", "Arnaut"),
	("tpe_name_18", "Arnold"),
	("tpe_name_19", "Aurelie"),
	("tpe_name_20", "Aycardus"),
	("tpe_name_21", "Baldwin"),
	("tpe_name_22", "Barthol"),
	("tpe_name_23", "Bartholomew"),
	("tpe_name_24", "Benedict"),
	("tpe_name_25", "Beraud"),
	("tpe_name_26", "Bernabo"),
	("tpe_name_27", "Bernard"),
	("tpe_name_28", "Bertrand"),
	("tpe_name_29", "Bodo"),
	("tpe_name_30", "Boucherd"),
	("tpe_name_31", "Carcie-Arnout"),
	("tpe_name_32", "Carlo"),
	("tpe_name_33", "Carlos"),
	("tpe_name_34", "Cesar"),
	("tpe_name_35", "Charles"),
	("tpe_name_36", "Claude"),
	("tpe_name_37", "Clement"),
	("tpe_name_38", "Connor"),
	("tpe_name_39", "Cosimo"),
	("tpe_name_40", "David"),
	("tpe_name_41", "Denis"),
	("tpe_name_42", "Dinus"),
	("tpe_name_43", "Edgar"),
	("tpe_name_44", "Edmund"),
	("tpe_name_45", "Edward"),
	("tpe_name_46", "Engelbert"),
	("tpe_name_47", "Enguerrand"),
	("tpe_name_48", "Enrique"),
	("tpe_name_49", "Ernauton"),
	("tpe_name_50", "Espan"),
	("tpe_name_51", "Etienne"),
	("tpe_name_52", "Eudes"),
	("tpe_name_53", "Eustance"),
	("tpe_name_54", "Felix"),
	("tpe_name_55", "Foucaud"),
	("tpe_name_56", "Francesco"),
	("tpe_name_57", "Francis"),
	("tpe_name_58", "Frank"),
	("tpe_name_59", "Gaston"),
	("tpe_name_60", "Gaucher"),
	("tpe_name_61", "Gautier"),
	("tpe_name_62", "Geoffrey"),
	("tpe_name_63", "George"),
	("tpe_name_64", "Georges"),
	("tpe_name_65", "Gerald"),
	("tpe_name_66", "Gerloch"),
	("tpe_name_67", "Gershon"),
	("tpe_name_68", "Giacomo"),
	("tpe_name_69", "Gigo"),
	("tpe_name_70", "Gilbert"),
	("tpe_name_71", "Gilles"),
	("tpe_name_72", "Giovanni"),
	("tpe_name_73", "Giroud"),
	("tpe_name_74", "Gracien"),
	("tpe_name_75", "Groynyn"),
	("tpe_name_76", "Gruffyd"),
	("tpe_name_77", "Guasbert"),
	("tpe_name_78", "Guedon"),
	("tpe_name_79", "Guglielmo"),
	("tpe_name_80", "Guichard"),
	("tpe_name_81", "Guichart"),
	("tpe_name_82", "Guillaume"),
	("tpe_name_83", "Guy"),
	("tpe_name_84", "Hal"),
	("tpe_name_85", "Heinrich"),
	("tpe_name_86", "Henri"),
	("tpe_name_87", "Henry"),
	("tpe_name_88", "Herve"),
	("tpe_name_89", "Hue"),
	("tpe_name_90", "Hugh"),
	("tpe_name_91", "Huguelin"),
	("tpe_name_92", "Hugues"),
	("tpe_name_93", "Humbert"),
	("tpe_name_94", "Humphrey"),
	("tpe_name_95", "Iacopo"),
	("tpe_name_96", "Ian"),
	("tpe_name_97", "Ingelram"),
	("tpe_name_98", "Irad"),
	("tpe_name_99", "Istfan"),
	("tpe_name_100", "Itan"),
	("tpe_name_101", "Jack"),
	("tpe_name_102", "Jacob"),
	("tpe_name_103", "Jacques"),
	("tpe_name_104", "Jaime"),
	("tpe_name_105", "James"),
	("tpe_name_106", "Jaun"),
	("tpe_name_107", "Jean"),
	("tpe_name_108", "Jeanne"),
	("tpe_name_109", "Jesus"),
	("tpe_name_110", "John"),
	("tpe_name_111", "Jomo"),
	("tpe_name_112", "Jonzac"),
	("tpe_name_113", "Joseph"),
	("tpe_name_114", "Joshua"),
	("tpe_name_115", "Joyeuse"),
	("tpe_name_116", "Juan"),
	("tpe_name_117", "Karl"),
	("tpe_name_118", "Karlito"),
	("tpe_name_119", "Kendal"),
	("tpe_name_120", "Lapurd"),
	("tpe_name_121", "Laurence"),
	("tpe_name_122", "Liam"),
	("tpe_name_123", "Lionel"),
	("tpe_name_124", "Lons"),
	("tpe_name_125", "Lorenc"),
	("tpe_name_126", "Loudeac"),
	("tpe_name_127", "Louhans"),
	("tpe_name_128", "Louis"),
	("tpe_name_129", "Lucchino"),
	("tpe_name_130", "Malachais"),
	("tpe_name_131", "Ludwig"),
	("tpe_name_132", "Marc"),
	("tpe_name_133", "Mastino"),
	("tpe_name_134", "Mathieu"),
	("tpe_name_135", "Maurice"),
	("tpe_name_136", "Max"),
	("tpe_name_137", "Mortimer"),
	("tpe_name_138", "Nicholas"),
	("tpe_name_139", "Norman"),
	("tpe_name_140", "Obizzo"),
	("tpe_name_141", "Odo"),
	("tpe_name_142", "Oleg"),
	("tpe_name_143", "Oliver"),
	("tpe_name_144", "Olivier"),
	("tpe_name_145", "Orian"),
	("tpe_name_146", "Othe"),
	("tpe_name_147", "Owain"),
	("tpe_name_148", "Owen"),
	("tpe_name_149", "Pablo"),
	("tpe_name_150", "Padre"),
	("tpe_name_151", "Paolo"),
	("tpe_name_152", "Pascal"),
	("tpe_name_153", "Pasqual"),
	("tpe_name_154", "Pedro"),
	("tpe_name_155", "Percy"),
	("tpe_name_156", "Peter"),
	("tpe_name_157", "Petrus"),
	("tpe_name_158", "Philippe"),
	("tpe_name_159", "Pierre"),
	("tpe_name_160", "Ralph"),
	("tpe_name_161", "Raniero"),
	("tpe_name_162", "Raoul"),
	("tpe_name_163", "Raymond"),
	("tpe_name_164", "Reginald"),
	("tpe_name_165", "Regnaut"),
	("tpe_name_166", "Renard"),
	("tpe_name_167", "Richard"),
	("tpe_name_168", "Robert"),
	("tpe_name_169", "Roger"),
	("tpe_name_170", "Roland"),
	("tpe_name_171", "Sean"),
	("tpe_name_172", "Seifried"),
	("tpe_name_173", "Simon"),
	("tpe_name_174", "Simone"),
	("tpe_name_175", "Sohier"),
	("tpe_name_176", "Stephen"),
	("tpe_name_177", "Sylvestre"),
	("tpe_name_178", "Tannequy"),
	("tpe_name_179", "Teodoro"),
	("tpe_name_180", "Thierry"),
	("tpe_name_181", "Thomas"),
	("tpe_name_182", "Toby"),
	("tpe_name_183", "Tomas"),
	("tpe_name_184", "Tomaso"),
	("tpe_name_185", "Tristan"),
	("tpe_name_186", "Umberto"),
	("tpe_name_187", "Wachter"),
	("tpe_name_188", "Walderon"),
	("tpe_name_189", "Waleron"),
	("tpe_name_190", "Wauthier"),
	("tpe_name_191", "William"),
	("tpe_name_192", "Yvain"),
	("male_name_end", "End"),
	
	# In-Combat Display Labels
	("tpe_red_team",         "Red Team"),
	("tpe_blue_team",        "Blue Team"),
	("tpe_green_team",       "Green Team"),
	("tpe_yellow_team",      "Yellow Team"),
	("tpe_reg5",             "{reg5}"),
	("tpe_s21",              "{s21}"),
	("tpe_icd_label_points", "Points"),
	("tpe_icd_label_troop",  "Participant"),
	("tpe_icd_label_team",   "Team"),
	("tpe_game_timer",       "Match Time - 0:00"),
	
	# Quest Descriptions
	("qp1_quest_desc_tournament_invited_by_s9_to_s13", "You have been invited by {s9} to attend the tournament being held in {s13}.  Turning down this invitation would be frowned upon."),
	("qp1_quest_desc_tournament_held_by_s9_to_s13", "You heard of a tournament being hosted by {s9} in the town of {s13}.  This would prove an excellent opportunity to prove your worth in these lands."),
	("qp1_tournaments_invited_by_s8_to_s12", "A messenger is allowed to pass into your camp by your men.  He leaves you with a sealed letter.  Within you find a formal invitation by {s8} to a tournament to be held in {s12}."),
	("qp1_tournaments_held_by_s8_in_s12", "During your day's travel, you come across a lone warrior traveling towards {s12}.  From him you learn that there will be a tournament held in the town by {s8}."),

	# Tournament Options Panel
	("tpe_label_bid_r2_amount_r3",  "{reg2} pts / {reg3} denars"),
	("tpe_label_long_bid",          "{reg2} pts @ {reg3}"),
	("tpe_message_round_bid",       "You have placed a wager to score {reg2} points."), # You place a bet of {reg0} denars before starting the round.  You have {reg1} denars remaining."),
	("tpe_message_round_cash_left", "Your wager has cost you {reg0} denars of your {reg1} denars remaining."), # You place a bet of {reg0} denars before starting the round.  You have {reg1} denars remaining."),
	("tpe_message_cant_cover_bet",  "You were unable to cover a wager of {reg0} denars."),
	("tpe_label_bid_payout_r4",     "Payout of {reg4} denars"),
	("tpe_label_difficulty_score",  "Difficulty Score"),
	
	# Tournament Design Panel Titles
	("tdp_label_done",              "Accept"),
	("tdp_label_enable_all",        "Enable All"),
	("tdp_label_native_settings",   "Native Settings"),
	("tdp_label_lance",             "Lances"),
	("tdp_label_onehand",           "One Handed Weapons"),
	("tdp_label_twohand",           "Two Handed Weapons"),
	("tdp_label_archery",           "Bows"),
	("tdp_label_crossbow",          "Crossbows"),
	("tdp_label_throwing",          "Thrown Weapons"),
	("tdp_label_polearm",           "Polearms"),
	("tdp_label_horse",             "Mounts"),
	("tdp_label_outfit",            "Setting Appearance"),
	("tdp_label_header",            "Tournament Design Settings"),
	("tdp_label_chance_header",     "Custom Setting"),
	("tdp_label_appearance",        "Appearance"),
	("tdp_label_center_list",       "Locations"),
	("tdp_label_disable",           "Unselect"),
	("tdp_label_reg21_percent",     "{reg21}%"),
	("tdp_label_test_scripts",      "Test Scripts"),
	("tdp_label_player_setting",    "Load^Chance"),
	("tdp_label_affect_all_cities", "Apply to All Centers"),
	
	# Friendly Fire Comments
	("tpe_friendly_fire_1", "Are you blind?!  Shoot at them, you lout!"),
	("tpe_friendly_fire_2", "Fool! Your aim is as bad as your breath!"),
	("tpe_friendly_fire_3", "Have you no shame, {knave/wench}?!"),
	("tpe_friendly_fire_4", "Are you color blind?  I am on your side!"),
	("tpe_friendly_fire_5", "I would more greatly fear your lack of loyalty, were you not such a poor shot!"),
	("tpe_friendly_fire_6", "You shall not rid yourself of me that easily, {playername}!"),
	("tpe_friendly_fire_end", "End"),
	
	# Tournament Credits & Information Panel
	("tci_exit",        "Exit"),
	("tci_main_topics", "Back"),
	("tci_main_title",  "Tournament Play Enhancements"),
	("tci_sub_title",   "Version 1.5"),
	
	# Tournament Information
	("tpe_info_0",   "Information Topics:"),
	("tpe_info_0a",  "Gameplay"),           # Reference strings tpe_info_1*
	("tpe_info_0b",  "Scoring"),            # Reference strings tpe_info_2*
	("tpe_info_0c",  "Betting"),            # Reference strings tpe_info_3*
	("tpe_info_0d",  "Options Panel"),      # Reference strings tpe_info_4*
	("tpe_info_0e",  "Design Panel"),       # Reference strings tpe_info_5*
	("tpe_info_0f",  "Rewards"),            # Reference strings tpe_info_6*
	("tpe_info_0g",  "Achievements"),       # Reference strings tpe_info_7*
	("tpe_info_0h",  "Credits"),            # Reference strings tpe_info_8*
	# Gameplay
	("tpe_info_1a",  "This mod represents a complete overhaul of the native tournament system."),
	("tpe_info_1b",  " "),
	("tpe_info_1c",  "The system for winning tournaments no longer rely primarily on surviving to be the"),
	("tpe_info_1d",  "'last man standing'.  Instead you earn points based upon performance with the winner"),
	("tpe_info_1e",  "being the participant with the most points accumulated.  After a tournament match"),
	("tpe_info_1f",  "you will be directed to a post-combat ranking screen that shows how everyone has"),
	("tpe_info_1g",  "performed on the current round and can be resorted to show total tournament rankings."),
	("tpe_info_1h",  " "),
	("tpe_info_1i",  "The AI participants have been substantially improved in capability.  Their selection"),
	("tpe_info_1j",  "of equipment is just as equally improved as your own and they will more dynamically"),
	("tpe_info_1k",  "switch between ranged and melee weapons."),
	("tpe_info_1l",  " "),
	("tpe_info_1m",  "Being knocked out in a tournament match will no longer cause disqualification or "),
	("tpe_info_1n",  "end the current round.  Your team may still continue on to 'win the round'."),
	# Scoring
	("tpe_info_2a",  "Tournament standing is now tracked by individual participant score instead"),
	("tpe_info_2b",  "of by simple survival.  This ensures that performance is the key factor in "),
	("tpe_info_2c",  "tournament ranking over simply being the last person standing."),
	("tpe_info_2d",  " "),
	("tpe_info_2e",  "You can increase your score by a number of ways:"),
	("tpe_info_2f",  "1) Defeating an opponent gains you 1 point."),
	("tpe_info_2g",  "2) Surviving to the end of a round gains you 2 points."),
	("tpe_info_2h",  "3) Being a member of the highest scoring team of a round gains you 1 point."),
	# Betting
	("tpe_info_3a",  "The betting system has been completely overhauled from native design."),
	("tpe_info_3b",  " "),
	("tpe_info_3c",  "You no longer need to set a bet prior to a match.  Your persistent bet"),
	("tpe_info_3d",  "setting in the options panel will be applied at the start of every match"),
	("tpe_info_3e",  "as long as you have the funds required."),
	("tpe_info_3f",  " "),
	("tpe_info_3g",  "Bets are now made using the 'wager' and 'bid' sliders.  Using the 'wager' slider"),
	("tpe_info_3h",  "you set how many denars you are willing to bet.  Using the 'bid' slider you set"),
	("tpe_info_3i",  "the difficulty of your bet by saying how many points you'll earn in the round."),
	("tpe_info_3j",  " "),
	("tpe_info_3k",  "The more you wager and the higher you bid, the larger your payout will be.  One"),
	("tpe_info_3l",  "thing to note is that the system does take into account how difficult obtaining your"),
	("tpe_info_3m",  "bid is.  Making a bid of 5 points is much easier in a match with 32 participants"),
	("tpe_info_3n",  "than in one with only 16 participants.  The payout will adjust accordingly."),
	# Options Panel
	("tpe_info_4a",  "The options panel covers most individual troop options whether for the player"),
	("tpe_info_4b",  "or for any companions currently within the player's party.  These may be"),
	("tpe_info_4c",  "selected individually for each person."),
	("tpe_info_4d",  " "),
	("tpe_info_4e",  "1) Equipment Choices - You may select three equipment items or benefits. "),
	("tpe_info_4f",  "Using the 'enhanced weapons' benefit will improve every weapon selected, but"),
	("tpe_info_4g",  "will not affect weapons picked up in the arena."),
	("tpe_info_4h",  " "),
	("tpe_info_4i",  "2) Never Spawn - This is only selectable for companions and will prevent"),
	("tpe_info_4j",  "them from being chosen to join in future tournaments."),
	("tpe_info_4k",  " "),
	("tpe_info_4l",  "3) Always Randomize - Using this your character will choose three options"),
	("tpe_info_4m",  "based upon the settings for that town per the tournament design panel.  The"),
	("tpe_info_4n",  "options chosen will be random in each match similar to native design."),
	("tpe_info_4o",  " "),
	("tpe_info_4p",  "4) Renown Scaling - This alters the renown earned for winning a tournament"),
	("tpe_info_4q",  "to be much higher at lower levels, but lower at higher levels.  If disabled"),
	("tpe_info_4r",  "you will receive the native amounts for renown and money."),
	("tpe_info_4s",  " "),
	("tpe_info_4t",  "5) Wager - This slider sets the amount the player wishes to bet at "),
	("tpe_info_4u",  "the start of every round as long as funds are available."),
	("tpe_info_4ua", " "),
	("tpe_info_4ub", "6) Bid - This slider sets how many points you are wagering that you will"),
	("tpe_info_4uc", "acquire during the round.  It no longer matters if you survive the round"),
	("tpe_info_4ud", "or not.  It only matters if you make your bid or not.  The higher you bid"),
	("tpe_info_4ue", "the better your payout listed below will be, however, the payout does take"),
	("tpe_info_4uf", "into account how hard it will be to make that bid.  Earning 5 points in a"),
	("tpe_info_4ug", "match with 32 participants is much easier than one with 12 participants."),
	("tpe_info_4v",  " "),
	("tpe_info_4w",  "7) Difficulty Setting - This alters the number of teams, the size of the"),
	("tpe_info_4x",  "teams and changes the difficulty of the generic participants.  This can be"),
	("tpe_info_4y",  "manually set or set to random."),
	("tpe_info_4z",  " "),
	("tpe_info_4aa", "8) Team Choice - You may leave your choice of teams random or specify one."),
	("tpe_info_4ab", " "),
	("tpe_info_4ac", "9) Level Scaling - This will cause enemies to automatically increase their"),
	("tpe_info_4ad", "level relative to your own to maintain a higher challenge.  This is off by"),
	("tpe_info_4ae", "default, but if turned on the effects are permanent from that point forward."),
	("tpe_info_4af", "A troop cannot lose levels so if he is ramped up that's his new minimum even"),
	("tpe_info_4ag", "if you turn the option off.  You may use this to set troops to stay at"),
	("tpe_info_4ah", "whatever difficulty you wish."),
	# Design Panel
	("tpe_info_5a",  "Within the tournament design panel you can designate many aspects of how"),
	("tpe_info_5b",  "each tournament will behave on a town by town basis.  Among these aspects:"),
	("tpe_info_5c",  " "),
	("tpe_info_5d",  "1) You can set which weapons will be available in the tournament.  This is"),
	("tpe_info_5e",  "done by setting the 'custom setting' slider to the desired strength.  Note"),
	("tpe_info_5f",  "that the 'load setting' percentages to the right determine the actual chance"),
	("tpe_info_5g",  "to have that specific type of weapon appear in play.  These items have been"),
	("tpe_info_5h",  "separated into three groups."),
	("tpe_info_5i",  " "),
	("tpe_info_5j",  "Melee - One and two handed weapons as well as polearms fall under"),
	("tpe_info_5k",  "this category.  A melee weapon must be selected or the system will default"),
	("tpe_info_5l",  "to using one handed weapons."),
	("tpe_info_5m",  " "),
	("tpe_info_5n",  "Ranged & Specialty - Bows, crossbows, thrown weapons and lances fall into"),
	("tpe_info_5o",  "this category.  This is done so that the AI treats them in a similar fashion."),
	("tpe_info_5p",  "There is no default for this category so if no option is selected no one will"),
	("tpe_info_5q",  "have a ranged weapon or lance."),
	("tpe_info_5r",  " "),
	("tpe_info_5s",  "Mounts - This is a direct representation of the percentage of how many"),
	("tpe_info_5t",  "mounted participants you want in a round.  Note that if the player has a"),
	("tpe_info_5u",  "horse selected as one of his own selections in the options panel then this"),
	("tpe_info_5v",  "setting will default to a minimum of 50%.  The exception to this is if you"),
	("tpe_info_5w",  "set the load chance to 0%.  This will override the player's mount and give"),
	("tpe_info_5x",  "him an alternative benefit (explained next) automatically."),
	("tpe_info_5y",  " "),
	("tpe_info_5ya", "Scene Setting - You can now choose which backdrop you'd prefer to play in."),
	("tpe_info_5yb", "If you select 'native arena' the native arenas will be used.  Selecting"),
	("tpe_info_5yc", "'Adorno's Overhaul Arena' will use the Arena Overhaul Mod scenes.  These"),
	("tpe_info_5yd", "choices may be made on a town by town basis."),
	("tpe_info_5ye", " "),
	("tpe_info_5z",  "Alternative Benefits - These are not selectable in the design screen, but"),
	("tpe_info_5aa", "exist as options for the AI or player to choose.  This group includes"),
	("tpe_info_5ab", "enhanced weaponry, enhanced armor, an upgrade to a warhorse or an enhanced"),
	("tpe_info_5ac", "shield.  If the AI's three options are not filled by the above three groups"),
	("tpe_info_5ad", "then they will select a benefit from this group."),
	("tpe_info_5ae", " "),
	("tpe_info_5af", "2) You can set what kinds of weapons by appearance will be used in a given"),
	("tpe_info_5ag", "tournament at that town.  This includes choosing between throwing axes over"),
	("tpe_info_5ah", "javelins or quarterstaffs instead of spears."),
	("tpe_info_5ai", " "),
	("tpe_info_5aj", "3) There are buttons below that allow you to change the current town or all"),
	("tpe_info_5ak", "towns (if the checkbox is selected) to 'native settings' or TPE default"),
	("tpe_info_5al", "settings ('enable all')."),
	# Rewards
	("tpe_info_6a",  "Final rewards are now granted to the top three placing participants of a"),
	("tpe_info_6b",  "tournament.  These rewards include an increase in renown, experience and"),
	("tpe_info_6c",  "money.  Second places earns approximately half of what first place does with"),
	("tpe_info_6d",  "third place earning about a quarter as much."),
	("tpe_info_6e",  " "),
	("tpe_info_6f",  "Winning a tournament will now give you change in reputation with every lord"),
	("tpe_info_6g",  "and lady present at the town based upon your current relation, their"),
	("tpe_info_6h",  "personality and your gender."),
	("tpe_info_6i",  " "),
	("tpe_info_6j",  "If enabled in the mod, items are also granted to the top three ranked"),
	("tpe_info_6k",  "competitors with quality modified by cumulative difficulty of the tournament"),
	("tpe_info_6l",  "matches, placement and other difficulty factors such as level scaling."),
	# Achievements
	("tpe_info_7a",  "Achievements are rewards that you are capable of winning each round.  These"),
	("tpe_info_7b",  "have specific requirements in order to be gained, but give experience and"),
	("tpe_info_7c",  "renown for earning them."),
	("tpe_info_7d",  " "),
	("tpe_info_7e",  "Swiftest Cut - Awarded for scoring the first defeat in a round."),
	("tpe_info_7f",  " "),
	("tpe_info_7g",  "Fiercest Competitor - Awarded for scoring the most defeats in a round."),
	("tpe_info_7h",  "   Note: This requires a minimum of 6 participants in the match."),
	("tpe_info_7i",  " "),
	("tpe_info_7j",  "Dominant Presence - Awarded for scoring 25+% of the defeats in a round."),
	("tpe_info_7k",  "   Note: This requires a minimum of 12 participants in the match."),
	("tpe_info_7l",  " "),
	("tpe_info_7m",  "Legendary Presence - Awarded for scoring 50+% of the defeats in a round."),
	("tpe_info_7n",  "   Note: This requires a minimum of 10 participants in the match."),
	("tpe_info_7o",  " "),
	("tpe_info_7p",  "Mythical Presence - Awarded for scoring 100% of the defeats in a round."),
	("tpe_info_7q",  "   Note: This requires a minimum of 10 participants in the match."),
	("tpe_info_7r",  " "),
	("tpe_info_7s",  "Cautious Approach - Awarded for surviving a round without scoring any points."),
	# Tournament Credits
	("tpe_info_8a",  "I want to thank everyone who has had a hand in helping with the creation or evolution of"),
	("tpe_info_8b",  "this system.  If I have missed anyone I apologize."),
	("tpe_info_8c",  " "),
	("tpe_info_8d",  "For their patience, scripting help and insightful ideas:"),
	("tpe_info_8e",  "The Floris Team"),
	("tpe_info_8ea", " - Monnikje"),
	("tpe_info_8eb", " - Duh"),
	("tpe_info_8ec", " - Caba'drin"),
	("tpe_info_8f",  " "),
	("tpe_info_8g",  "The beta testers that helped influence much of the design from 1.3 on:"),
	("tpe_info_8h",  "Duh"),
	("tpe_info_8i",  "Ogrecorps"),
	("tpe_info_8j",  "Shapic"),
	("tpe_info_8k",  " "),
	("tpe_info_8l",  "The artists who have work included within the kit:"),
	("tpe_info_8m",  "Monnikje"),
	("tpe_info_8ma", "wanderer949"),
	("tpe_info_8mb", "ZIRA"),
	("tpe_info_8mc", "Michal"),
	("tpe_info_8md", "SPAK"),
	("tpe_info_8me", "thick1988"),
	("tpe_info_8n",  " "),
	("tpe_info_8o",  "Forum personalities that helped guide further development:"),
	("tpe_info_8p",  "Hyde911"),
	("tpe_info_8q",  "wingcutangel"),
	("tpe_info_8r",  "eastpaw"),
	("tpe_info_8s",  " "),
	("tpe_info_8t",  "The following folks for their OSP work that is utilized by TPE:"),
	("tpe_info_8u",  "Modmerger Framework (0.2.5) by Sphere"),
	("tpe_info_8v",  "PreBattle Deployment & Orders (0.91) by Caba'drin"),
	("tpe_info_8w",  " - Shield Bash, based on initial design by Xenoargh"),
	("tpe_info_8x",  " - Death Camera, based on initial design by MadVader"),
	("tpe_info_8y",  "Custom Commander (1.329) by Rubik"),
	("tpe_info_8z",  " - The ability to enable health bars above enemies and allies."),
	("tpe_info_8aa", "Arena Overhaul (1.0) by Adorno"),
	("tpe_info_8ab", " - This overhaul of the scenery enhances the tactical feel of"),
	("tpe_info_8ac", "   choosing your own equipment options."),
	("tpe_info_8ad", " "),
	("tpe_info_8ae", "And last, the folks who's OSP work helped inspire some of my own:"),
	("tpe_info_8af", "Jrider      - OSP presentations"),
	("tpe_info_8ag", "Rubik      - Custom Commander presentations"),
	("tpe_info_8ah", "Lazeras    - Weapon switching script"),
	("tpe_info_8ah1","Jik          - Module system guide"),
	("tpe_info_8ai", " "),
	("tpe_info_8aj", "Thanks,"),
	("tpe_info_8ak", "Windyplains"),
	# Placeholder
	("tpe_info_9a",  "xxx"),
]

from util_common import *

def modmerge_strings(orig_strings):
    # add remaining strings
    from util_common import add_objects
    num_appended, num_replaced, num_ignored = add_objects(orig_strings, strings)
    #print num_appended, num_replaced, num_ignored
	
	
# Used by modmerger framework version >= 200 to merge stuff
# This function will be looked for and called by modmerger if this mod is active
# Do not rename the function, though you can insert your own merging calls where indicated
def modmerge(var_set):
    try:
        var_name_1 = "strings"
        orig_strings = var_set[var_name_1]
        modmerge_strings(orig_strings)
    except KeyError:
        errstring = "Variable set does not contain expected variable: \"%s\"." % var_name_1
        raise ValueError(errstring)